Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long


Public Const WH_CALLWNDPROC = 4
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6
Public Const WH_KEYBOARD_LL = 13
Public Const WH_MOUSE_LL = 14


Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4

Private Const WHEEL_DELTA = 120

Private Const LLKHF_EXTENDED = &H1      'Test the extended-key flag
Private Const LLKHF_INJECTED = &H10     'Test the event-injected flag
Private Const LLKHF_ALTDOWN = &H20      'Test the context code
Private Const LLKHF_UP = &H80           'Test the transition-state flag

Private Const LLMHF_INJECTED = &H1      'Test the event-injected flag
Private Const WM_MOUSEWHEEL = &H20A

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSLLHOOKSTRUCT
    pt As POINTAPI
    mouseData As Long
    flags As Long
    time As Long
    dwExtraInfo As Long
End Type

Public Type DEBUGHOOKINFO
        hModuleHook As Long
        Reserved As Long
        lParam As Long
        wParam As Long
        code As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Public Type CWPSTRUCT
        lParam As Long
        wParam As Long
        message As Long
        hwnd As Long
End Type

Public Type MOUSEHOOKSTRUCT
        pt As POINTAPI
        hwnd As Long
        wHitTestCode As Long
        dwExtraInfo As Long
End Type

'This structure replaces MOUSEHOOKSTRUCT and is only valid in Windows 2000 and above
'  - The HIWORD of the MouseData member defines either
'      - The Mouse Wheel Delta or
'      - Which XButton was pressed or released (XBUTTON1 or XBUTTON2)
Public Type MOUSEHOOKSTRUCTEX
    structMouseHook As MOUSEHOOKSTRUCT
    mouseData As Long
End Type


Private hHook As Long
Public IsHooked As Boolean


'-----------------------------
' SET MESSAGE FILTER HOOK
'-----------------------------
Public Sub SetMouseHook()
    If IsHooked Then
        MsgBox "Don't hook the MOUSE_LL hook twice or you will be unable to unhook it."
    Else
        'This has to be set up as a system-wide hook
        hHook = SetWindowsHookEx(WH_MOUSE_LL, AddressOf MouseProc, App.hInstance, 0)
        IsHooked = True
    End If
End Sub

Public Sub RemoveMouseHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hHook)
    IsHooked = False
End Sub


Public Function MouseProc(ByVal uCode As Long, ByVal wParam As Long, lParam As MSLLHOOKSTRUCT) As Long
    Dim strInjected As String
    
    If uCode >= 0 Then
        If LLMHF_INJECTED And lParam.flags Then
            strInjected = "Injected"
        Else
            strInjected = "Not Injected"
        End If
        
        If wParam = WM_MOUSEWHEEL Then
            If CLng(lParam.mouseData And &HFFFF0000) > 0 Then
                Form2.lblWheelInfo = "Forward"
            Else
                Form2.lblWheelInfo = "Backwards"
            End If
        Else
            Form2.lblBttnInfo = CStr(lParam.mouseData And &HFFFF0000)
        End If
        
        Form2.lblX.Caption = lParam.pt.x
        Form2.lblY.Caption = lParam.pt.y
        
        Select Case uCode
            Case HC_ACTION
                Form2.Text1.Text = Form2.Text1.Text & "HC_ACTION    MSG:" & Hex$(wParam) & "    Extra Info:" & lParam.dwExtraInfo & "    Time:" & lParam.time & "    " & strInjected & vbNewLine
            Case HC_NOREMOVE
                Form2.Text1.Text = Form2.Text1.Text & "HC_NOREMOVE    MSG:" & Hex$(wParam) & "    Extra Info:" & lParam.dwExtraInfo & "    Time:" & lParam.time & "    " & strInjected & vbNewLine
            Case Else
        End Select
    Else
        Form2.Text1.Text = "NA" & vbNewLine
    End If
            
    MouseProc = CallNextHookEx(hHook, uCode, wParam, lParam)
End Function

